% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_brainGraph.R
\name{plot.brainGraph_NBS}
\alias{plot.brainGraph_NBS}
\title{Plot a graph with results from the network-based statistic}
\usage{
\method{plot}{brainGraph_NBS}(x, alpha = 0.05, subgraph = paste("p.nbs >", 1
  - alpha), vertex.label = NA, vertex.color = "color.comp",
  edge.color = "color.comp", subt = NULL, main = paste0("\\n\\nNBS: ",
  x$name), cex.main = 2, ...)
}
\arguments{
\item{x}{A \code{brainGraph_NBS} graph object (from
\code{\link{make_nbs_brainGraph}})}

\item{alpha}{Numeric; the significance level (default: 0.05)}

\item{subgraph}{Character string specifying the condition for subsetting the
graph. By default, it will show only the vertices which are members of
components determined to be significant based on \code{alpha}.}

\item{vertex.label}{Character vector of the vertex labels to be displayed.
Default behavior is to omit them.}

\item{vertex.color}{Character string specifying the vertex attribute to color
the vertices by (default: \code{color.comp}, which groups vertices by
connected component)}

\item{edge.color}{Character string specifying the edge attribute to color
the edges by (default: \code{color.comp}, which groups edges by connected
component)}

\item{subt}{Character string; the subtitle (default: \code{default})}

\item{main}{Character string; the main title (default: \code{NULL})}

\item{cex.main}{Numeric; the scaling factor for text size; see
\code{\link[graphics]{par}} (default: 2)}

\item{...}{Other arguments passed to \code{\link{plot.brainGraph}}}
}
\description{
This is a convenience function for plotting a graph based on results from
\code{\link{NBS}}. There are several default arguments that are set:
vertex/edge colors will correspond to connected component membership, and
only those vertices in which \code{V(g)$p.nbs > 1 - alpha} will be shown.
Finally, vertex names will be omitted.
}
\seealso{
Other Plotting functions: \code{\link{plot.brainGraph_GLM}},
  \code{\link{plot.brainGraph_mediate}},
  \code{\link{plot.brainGraph_mtpc}},
  \code{\link{plot.brainGraph}},
  \code{\link{plot_brainGraph_gui}},
  \code{\link{plot_brainGraph_list}},
  \code{\link{plot_brainGraph_multi}}
}
