% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tguh_denoise.R
\name{tguh.denoise}
\alias{tguh.denoise}
\title{Noise removal from Tail-Greedy Unbalanced Haar coefficients via connected thresholding}
\usage{
tguh.denoise(tguh.decomp.obj, lambda, minseglen = 1, bal = 1/20)
}
\arguments{
\item{tguh.decomp.obj}{A variable returned by \code{tguh.decomp} or \code{tguh.denoise}.}

\item{lambda}{The threshold value.}

\item{minseglen}{The minimum permitted length of either wing of any Unbalanced Haar wavelet whose
corresponding coefficient survives the thresholding.}

\item{bal}{The minimum permitted ratio of the length of either wing to the sum of the lengths of both wings of
any Unbalanced Haar wavelet whose corresponding coefficient survives the thresholding.}
}
\value{
Modified object \code{tguh.decomp.obj}; the modification is that the detail coefficients
in the \code{decomp.hist} field that do not survive the thresholding get set to zero.
}
\description{
This function performs the connected thresholding of the Tail-Greedy Unbalanced Haar 
coefficients.
}
\details{
Typically, the first parameter of \code{tguh.denoise} will be an object returned by
\code{tguh.decomp}. The function \code{tguh.denoise} performs the "connected thresholding"
of this object, in the sense that if a Tail-Greedy Unbalanced Haar detail coefficient does
not have any surviving children coefficients, then it gets set to zero if it falls under
the threshold, or if the corresponding Unbalanced Haar wavelet is too unbalanced or has too
short a wing. See "Tail-greedy bottom-up data decompositions and fast multiple change-point 
detection", P. Fryzlewicz (2017), preprint, for details.
}
\examples{
rnoise <- rnorm(10)
rnoise.tguh <- tguh.decomp(rnoise)
print(rnoise.tguh)
rnoise.denoise <- tguh.denoise(rnoise.tguh, 3)
rnoise.clean <- tguh.reconstr(rnoise.denoise)
print(rnoise.clean)
}
\seealso{
\code{\link{tguh.cpt}}, \code{\link{tguh.decomp}}, \code{\link{tguh.reconstr}}
}
\author{
Piotr Fryzlewicz, \email{p.fryzlewicz@lse.ac.uk}
}
