% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breathtestfit_broom.R
\name{augment.breathtestfit}
\alias{augment.breathtestfit}
\title{Augmented prediction for breathtest fit}
\usage{
\method{augment}{breathtestfit}(x, by = NULL, minute = NULL,
  dose = 100, ...)
}
\arguments{
\item{x}{Object of class \code{breathttestfit}}

\item{by}{When \code{by} is NULL, predictions for the original data values
are returned.  When \code{by} is a positive number, it is used as a step 
size for a sequence of minutes from 0 to the maximum value of minute in data set.}

\item{minute}{When a vector is passed, this overrides settings in \code{by},
and predictions are calculated at the requested minute values.}

\item{dose}{13C acetate or octanoate dose}

\item{...}{other parameters passed to methods}
}
\value{
When \code{by} is NULL,  returns one row for each 
original observation pdr, and column \code{fitted}. If new data are given, 
i.e. when one of parameter \code{by} or \code{minute} is not null, 
only column \code{fitted} is added.
}
\description{
Broom method \code{\link[broom]{augment}} to compute predicted values 
from  the results of class \code{breathttestfit}  as generated by  
\code{\link{nls_fit}} or \code{\link{nlme_fit}}.
}
\examples{
library(broom)
# Generate simulated data
data = cleanup_data(simulate_breathtest_data(n_records = 3)$data)
# Fit using the curves individually
fit = nls_fit(data)
# Predict values at t=60 and t=120
augment(fit, minute = c(60, 120))

}
\seealso{
\code{\link[broom]{augment}}
}
