% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breathtest_parameters.R
\name{tlag_maes_ghoos}
\alias{tlag_maes_ghoos}
\title{So-called lag time from Maes/Ghoos fit}
\usage{
tlag_maes_ghoos(cf)
}
\arguments{
\item{cf}{named vector of coefficients; only \code{k} and \code{beta} are required
\code{k} is measured in 1/min (e.g. 0.01/min).}
}
\value{
Lag time as defined from Maes/Ghoos fit
}
\description{
Computes \code{tlag} from uncorrected fit to the beta 
exponential function. The name \code{tlag} is a misnomer; it simply 
is the maximum of the PDR curve, so in papers by Bluck et al. it is renamed to t_max.

Maes B D, Ghoos Y F, Rutgeerts P J, Hiele M I, Geypens B and Vantrappen G 1994 
Dig. Dis. Sci. 39 S104-6.
}
\seealso{
\code{\link{exp_beta}}, and \code{\link{t50_bluck_coward}} for an example.
}
