% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_infinite_estimates.R
\name{detect_infinite_estimates.glm}
\alias{detect_infinite_estimates.glm}
\title{A simple check of whether the maximum likelihood estimates are infinite}
\usage{
\method{detect_infinite_estimates}{glm}(object, nsteps = 30, ...)
}
\arguments{
\item{object}{the result of a \code{\link{glm}} call}

\item{nsteps}{starting from \code{maxit = 1}, the GLM is refitted
for \code{maxit = 2}, \code{maxit = 3}, \ldots, \code{maxit =
nsteps}. Default value is 30.}

\item{...}{currently not used#'}
}
\description{
A simple check of whether the maximum likelihood estimates are infinite
}
\details{
\code{detect_infinite_estimates} attempts to identify the occurence
of infinite estimates in GLMs with binomial responses by
successively refitting the model. At each iteration the maximum
number of allowed IWLS iterations is fixed starting from 1 to
\code{nsteps} (by setting \code{control = glm.control(maxit = j)},
where \code{j} takes values 1, \ldots, nsteps in
\code{\link{glm}}). For each value of \code{maxit}, the estimated
asymptotic standard errors are divided to the corresponding ones
from \code{control = glm.control(maxit = 1)}. Then, based on the
results in Lesaffre & Albert (1989), if the sequence of ratios in
any column of the resultant matrix diverges, then complete or
quasi-complete separation occurs and the maximum likelihood
estimate for the corresponding parameter has value minus or plus
infinity.
}
\examples{

## endometrial data from Heinze \\& Schemper (2002) (see ?endometrial)
data("endometrial", package = "brglm2")
endometrialML <- glm(HG ~ NV + PI + EH, data = endometrial,
                     family = binomial("probit"))
## clearly the maximum likelihood estimate for the coefficient of
## NV is infinite
detect_infinite_estimates(endometrialML)

}
\references{
Lesaffre, E., & Albert, A. (1989). Partial Separation in Logistic
Discrimination. *Journal of the Royal Statistical Society. Series B
(Methodological)*, **51**, 109-116
}
\seealso{
\code{\link[nnet]{multinom}}
}

