% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getUserHash.R
\name{getUserHash}
\alias{getUserHash}
\title{Returns the user hash from Brickset.}
\usage{
getUserHash(
  username = getOption("brickset_username"),
  password = getOption("brickset_password"),
  key = getOption("brickset_key")
)
}
\arguments{
\item{username}{the Brickset username.}

\item{password}{the Brickset password.}

\item{key}{the Brickset API key.}
}
\value{
the user hash for the current API session.
}
\description{
Many of the Brickset API calls require a user to login. This function wraps
the \code{\link{login}} function to managing the user hash returned from
login across multiple API calls. It will also ensure that the hash is still
valid and if it expired a new hash will be requested.
}
\details{
Brickset API documentation is available here:
https://brickset.com/article/52664/api-version-3-documentation/
}
