% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libraries.R
\name{db_libs_uninstall}
\alias{db_libs_uninstall}
\title{Uninstall Library on Cluster}
\usage{
db_libs_uninstall(
  cluster_id,
  libraries,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{cluster_id}{Unique identifier of a Databricks cluster.}

\item{libraries}{An object created by \code{\link[=libraries]{libraries()}} and the appropriate
\verb{lib_*()} functions.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Uninstall Library on Cluster
}
\details{
The libraries aren’t uninstalled until the cluster is restarted.

Uninstalling libraries that are not installed on the cluster has no impact
but is not an error.
}
\seealso{
Other Libraries API: 
\code{\link{db_libs_all_cluster_statuses}()},
\code{\link{db_libs_cluster_status}()},
\code{\link{db_libs_install}()}
}
\concept{Libraries API}
