% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_marginal_draws_average.R
\name{brm_marginal_draws_average}
\alias{brm_marginal_draws_average}
\title{Average marginal MCMC draws across time points.}
\usage{
brm_marginal_draws_average(draws, data, times = NULL, label = "average")
}
\arguments{
\item{draws}{Fitted \code{brms} model object from \code{\link[=brm_model]{brm_model()}}.}

\item{data}{Classed tibble with preprocessed data from \code{\link[=brm_data]{brm_data()}}.}

\item{times}{Character vector of discrete time point levels
over which to average the MCMC samples within treatment group levels.
Set to \code{NULL} to average across all time points. Levels are automatically
sanitized with \code{make.names(unique = FALSE, allow_ = TRUE)} to ensure
agreement with \code{brms} variable names in downstream computations.}

\item{label}{Character of length 1, time point label for the averages.
Automatically sanitized with \code{make.names(unique = FALSE, allow_ = TRUE)}.
Must not conflict with any existing time point labels in the data
after the label and time points are sanitized.}
}
\value{
A named list of tibbles of MCMC draws of the marginal posterior
distribution of each treatment group.
\itemize{
\item \code{response}: on the scale of the response variable.
\item \code{change}: change from baseline, where the \code{baseline} argument determines
the time point at baseline. Only returned if the \code{role} argument is
\code{"response"}. (If \code{role} is \code{"change"}, then \code{response} already
represents change from baseline.)
\item \code{difference}: treatment effect of change from baseline, where the
\code{control} argument identifies the placebo or active control group.
In each tibble, there is 1 row per posterior sample and one column for
each treatment group. There is a time point label which is called
\code{"average"} by default.
}
}
\description{
Simple un-weighted arithmetic mean of
marginal MCMC draws across time points.
}
\section{Separation string}{

Post-processing in \code{\link[=brm_marginal_draws]{brm_marginal_draws()}} names each of the
group-by-time marginal means with the delimiting character string
from \code{Sys.getenv("BRM_SEP", unset = "|")}. Neither the column names
nor element names of the group and time variables can contain
this string. To set a custom string yourself, use
\code{Sys.setenv(BRM_SEP = "YOUR_CUSTOM_STRING")}.
}

\examples{
if (identical(Sys.getenv("BRM_EXAMPLES", unset = ""), "true")) {
set.seed(0L)
data <- brm_data(
  data = brm_simulate()$data,
  outcome = "response",
  role = "response",
  group = "group",
  time = "time",
  patient = "patient"
)
formula <- brm_formula(
  data = data,
  effect_base = FALSE,
  interaction_base = FALSE
)
tmp <- utils::capture.output(
  suppressMessages(
    suppressWarnings(
      model <- brm_model(
        data = data,
        formula = formula,
        chains = 1,
        iter = 100,
        refresh = 0
      )
    )
  )
)
draws <- brm_marginal_draws(
  model = model,
  data = data,
  control = "group 1",
  baseline = "time 1"
)
brm_marginal_draws_average(draws = draws, data = data)
brm_marginal_draws_average(
  draws = draws,
  data = data,
  times = c("time 1", "time 2"),
  label = "mean"
)
}
}
\seealso{
Other marginals: 
\code{\link{brm_marginal_data}()},
\code{\link{brm_marginal_draws}()},
\code{\link{brm_marginal_probabilities}()},
\code{\link{brm_marginal_summaries}()}
}
\concept{marginals}
