% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula-helpers.R
\name{gr}
\alias{gr}
\title{Set up basic grouping terms in \pkg{brms}}
\usage{
gr(...)
}
\arguments{
\item{...}{One or more terms containing grouping factors.}
}
\description{
Function used to set up a basic grouping term in \pkg{brms}.
The function does not evaluate its arguments --
it exists purely to help set up a model with grouping terms.
\code{gr} is called implicitely inside the package
and there is usually no need to call it directly.
}
\examples{
\dontrun{
# model using basic lme4-style formula
fit1 <- brm(count ~ Trt_c + (1|patient), data = epilepsy)
summary(fit1)
# equivalent model using 'gr' which is called anyway internally
fit2 <- brm(count ~ Trt_c + (1|gr(patient)), data = epilepsy)
summary(fit2)
WAIC(fit1, fit2)
}

}
\seealso{
\code{\link[brms:brmsformula]{brmsformula}}
}
