% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula-ac.R
\name{car}
\alias{car}
\title{Spatial conditional autoregressive (CAR) structures}
\usage{
car(M, gr = NA, type = "escar")
}
\arguments{
\item{M}{Adjacency matrix of locations. All non-zero entries are treated as
if the two locations are adjacent. If \code{gr} is specified, the row names
of \code{M} have to match the levels of the grouping factor.}

\item{gr}{An optional grouping factor mapping observations to spatial
locations. If not specified, each observation is treated as a separate
location. It is recommended to always specify a grouping factor to allow
for handling of new data in post-processing methods.}

\item{type}{Type of the CAR structure. Currently implemented are
\code{"escar"} (exact sparse CAR), \code{"esicar"} (exact sparse intrinsic
CAR), \code{"icar"} (intrinsic CAR), and \code{"bym2"}. More information is
provided in the 'Details' section.}
}
\value{
An object of class \code{'car_term'}, which is a list
  of arguments to be interpreted by the formula
  parsing functions of \pkg{brms}.
}
\description{
Set up an spatial conditional autoregressive (CAR) term in \pkg{brms}. The
function does not evaluate its arguments -- it exists purely to help set up a
model with CAR terms.
}
\details{
The \code{escar} and \code{esicar} types are
  implemented based on the case study of Max Joseph
  (\url{https://github.com/mbjoseph/CARstan}). The \code{icar} and
  \code{bym2} type is implemented based on the case study of Mitzi Morris
  (\url{https://mc-stan.org/users/documentation/case-studies/icar_stan.html}).
}
\examples{
\dontrun{
# generate some spatial data
east <- north <- 1:10
Grid <- expand.grid(east, north)
K <- nrow(Grid)

# set up distance and neighbourhood matrices
distance <- as.matrix(dist(Grid))
W <- array(0, c(K, K))
W[distance == 1] <- 1

# generate the covariates and response data
x1 <- rnorm(K)
x2 <- rnorm(K)
theta <- rnorm(K, sd = 0.05)
phi <- rmulti_normal(
  1, mu = rep(0, K), Sigma = 0.4 * exp(-0.1 * distance)
)
eta <- x1 + x2 + phi
prob <- exp(eta) / (1 + exp(eta))
size <- rep(50, K)
y <- rbinom(n = K, size = size, prob = prob)
dat <- data.frame(y, size, x1, x2)

# fit a CAR model
fit <- brm(y | trials(size) ~ x1 + x2 + car(W),
           data = dat, data2 = list(W = W),
           family = binomial())
summary(fit)
}

}
\seealso{
\code{\link{autocor-terms}}
}
