% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stanvars.R
\name{stanvar}
\alias{stanvar}
\alias{stanvars}
\title{User-defined variables passed to Stan}
\usage{
stanvar(x, name = NULL, scode = NULL)
}
\arguments{
\item{x}{An \R object containing data to be passed to Stan.}

\item{name}{Optinal character string providing the desired variable 
name of the object in \code{x}. If \code{NULL} (the default)
the variable name is directly infered from \code{x}.}

\item{scode}{Optional line of Stan code to define the variable
in Stan's data block. If \code{NULL} (the default), the
Stan code is inferred based on the class of \code{x}.}
}
\value{
An object of class \code{stanvars}.
}
\description{
Prepare user-defined variables to be passed to Stan's data block.
This is primarily useful for defining more complex priors and 
for refitting models without recompilation despite changing priors.
}
\examples{
bprior <- prior(normal(mean_intercept, 10), class = "Intercept")
stanvars <- stanvar(5, name = "mean_intercept")
make_stancode(count ~ Trt, epilepsy, prior = bprior, 
              stanvars = stanvars)
              
# define a multi-normal prior with known covariance matrix
bprior <- prior(multi_normal(M, V), class = "b")
stanvars <- stanvar(rep(0, 2), "M", scode = "  vector[K] M;") +
  stanvar(diag(2), "V", scode = "  matrix[K, K] V;") 
make_stancode(count ~ Trt + log_Base4_c, epilepsy,
              prior = bprior, stanvars = stanvars)

}
