% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample-frac-n-keys.R
\name{sample-n-frac-keys}
\alias{sample-n-frac-keys}
\alias{sample_n_keys}
\alias{sample_frac_keys}
\title{Sample a number or fraction of keys to explore}
\usage{
sample_n_keys(.data, size)

sample_frac_keys(.data, size)
}
\arguments{
\item{.data}{tsibble object}

\item{size}{The number or fraction of observations, depending on the
function used. In \code{sample_n_keys}, it is a number > 0, and in
\code{sample_frac_keys} it is a fraction, between 0 and 1.}
}
\value{
tsibble with fewer observations of key
}
\description{
Sample a number or fraction of keys to explore
}
\examples{
library(ggplot2)
sample_n_keys(heights,
             size = 10) \%>\%
  ggplot(aes(x = year,
             y = height_cm,
             group = country)) + 
  geom_line()
library(ggplot2)
sample_frac_keys(wages,
                0.1) \%>\%
  ggplot(aes(x = xp,
             y = unemploy_rate,
             group = id)) + 
  geom_line()
}
