% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_rows.R
\name{compare_rows}
\alias{compare_rows}
\title{Compare rows in a matrix}
\usage{
compare_rows(mat, method = c("prop_mismatches", "rms_difference"))
}
\arguments{
\item{mat}{Numeric matrix. Should be integers in the case \code{method="prop_mismatches"}.}

\item{method}{Indicates whether to use proportion mismatches or the
RMS difference. Missing values are omitted.}
}
\value{
A square matrix of dimension \code{nrow(mat)} with
\code{NA}s on the diagonal and the calculated statistic in the
body.
}
\description{
For all pairs of rows in a matrix, calculate the proportion of mismatches or the RMS difference.
}
\examples{
n <- 10
p <- 200
x <- matrix(sample(1:4, n*p, replace=TRUE), ncol=p)
d <- compare_rows(x)
}
