% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_select_variables.R
\name{tidy_select_variables}
\alias{tidy_select_variables}
\title{Select variables to keep/drop}
\usage{
tidy_select_variables(x, include = everything(), model = tidy_get_model(x))
}
\arguments{
\item{x}{a tidy tibble}

\item{include}{variables to include. Accepts \link[dplyr:select]{tidyselect}
syntax. Use \code{-} to remove a variable. Default is \code{everything()}.
See also \code{\link[=all_continuous]{all_continuous()}}, \code{\link[=all_categorical]{all_categorical()}}, \code{\link[=all_dichotomous]{all_dichotomous()}}
and \code{\link[=all_interaction]{all_interaction()}}}

\item{model}{the corresponding model, if not attached to \code{x}}
}
\value{
The \code{x} tibble limited to the included variables (and eventually the intercept),
sorted according to the \code{include} parameter.
}
\description{
Will remove unselected variables from the results.
To remove the intercept, use \code{\link[=tidy_remove_intercept]{tidy_remove_intercept()}}.
}
\details{
If the \code{variable} column is not yet available in \code{x},
\code{\link[=tidy_identify_variables]{tidy_identify_variables()}} will be automatically applied.
}
\examples{
res <- Titanic \%>\%
  dplyr::as_tibble() \%>\%
  dplyr::mutate(Survived = factor(Survived)) \%>\%
  glm(Survived ~ Class + Age * Sex, data = ., weights = .$n, family = binomial) \%>\%
  tidy_and_attach() \%>\%
  tidy_identify_variables()

res
res \%>\% tidy_select_variables()
res \%>\% tidy_select_variables(include = "Class")
res \%>\% tidy_select_variables(include = -c("Age", "Sex"))
res \%>\% tidy_select_variables(include = starts_with("A"))
res \%>\% tidy_select_variables(include = all_categorical())
res \%>\% tidy_select_variables(include = all_dichotomous())
res \%>\% tidy_select_variables(include = all_interaction())
res \%>\% tidy_select_variables(
  include = c("Age", all_categorical(dichotomous = FALSE), all_interaction())
)
}
\seealso{
Other tidy_helpers: 
\code{\link{tidy_add_coefficients_type}()},
\code{\link{tidy_add_contrasts}()},
\code{\link{tidy_add_estimate_to_reference_rows}()},
\code{\link{tidy_add_header_rows}()},
\code{\link{tidy_add_n}()},
\code{\link{tidy_add_pairwise_contrasts}()},
\code{\link{tidy_add_reference_rows}()},
\code{\link{tidy_add_term_labels}()},
\code{\link{tidy_add_variable_labels}()},
\code{\link{tidy_attach_model}()},
\code{\link{tidy_disambiguate_terms}()},
\code{\link{tidy_identify_variables}()},
\code{\link{tidy_plus_plus}()},
\code{\link{tidy_remove_intercept}()}
}
\concept{tidy_helpers}
