% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_identify_variables.R
\name{tidy_identify_variables}
\alias{tidy_identify_variables}
\title{Identify the variable corresponding to each model coefficient}
\usage{
tidy_identify_variables(x, model = tidy_get_model(x), quiet = FALSE)
}
\arguments{
\item{x}{(\code{data.frame})\cr
A tidy tibble as produced by \verb{tidy_*()} functions.}

\item{model}{(a model object, e.g. \code{glm})\cr
The corresponding model, if not attached to \code{x}.}

\item{quiet}{(\code{logical})\cr
Whether \code{broom.helpers} should not return a message when requested output
cannot be generated. Default is \code{FALSE}.}
}
\description{
\code{tidy_identify_variables()} will add to the tidy tibble
three additional columns: \code{variable}, \code{var_class}, \code{var_type} and \code{var_nlevels}.
}
\details{
It will also identify interaction terms and intercept(s).

\code{var_type} could be:
\itemize{
\item \code{"continuous"},
\item \code{"dichotomous"} (categorical variable with 2 levels),
\item \code{"categorical"} (categorical variable with 3 levels or more),
\item \code{"intercept"}
\item \code{"interaction"}
\item \verb{"ran_pars} (random-effect parameters for mixed models)
\item \code{"ran_vals"} (random-effect values for mixed models)
\item \code{"unknown"} in the rare cases where \code{tidy_identify_variables()}
will fail to identify the list of variables
}

For dichotomous and categorical variables, \code{var_nlevels} corresponds to the number
of original levels in the corresponding variables.
}
\examples{
df <- Titanic |>
  dplyr::as_tibble() |>
  dplyr::mutate(Survived = factor(Survived, c("No", "Yes")))
glm(
  Survived ~ Class + Age * Sex,
  data = df,
  weights = df$n,
  family = binomial
) |>
  tidy_and_attach() |>
  tidy_identify_variables()

lm(
  Sepal.Length ~ poly(Sepal.Width, 2) + Species,
  data = iris,
  contrasts = list(Species = contr.sum)
) |>
  tidy_and_attach(conf.int = TRUE) |>
  tidy_identify_variables()
}
\seealso{
\code{\link[=model_identify_variables]{model_identify_variables()}}

Other tidy_helpers: 
\code{\link{tidy_add_coefficients_type}()},
\code{\link{tidy_add_contrasts}()},
\code{\link{tidy_add_estimate_to_reference_rows}()},
\code{\link{tidy_add_header_rows}()},
\code{\link{tidy_add_n}()},
\code{\link{tidy_add_pairwise_contrasts}()},
\code{\link{tidy_add_reference_rows}()},
\code{\link{tidy_add_term_labels}()},
\code{\link{tidy_add_variable_labels}()},
\code{\link{tidy_attach_model}()},
\code{\link{tidy_disambiguate_terms}()},
\code{\link{tidy_plus_plus}()},
\code{\link{tidy_remove_intercept}()},
\code{\link{tidy_select_variables}()}
}
\concept{tidy_helpers}
