% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle2_tidiers.R
\name{mle2_tidiers}
\alias{mle2_tidiers}
\alias{tidy.mle2}
\title{Tidy mle2 maximum likelihood objects}
\usage{
\method{tidy}{mle2}(x, conf.int = FALSE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{An "mle2" object}

\item{conf.int}{Whether to add \code{conf.low} and \code{conf.high} columns}

\item{conf.level}{Confidence level to use for interval}

\item{...}{Extra arguments, not used}
}
\description{
Tidy mle2 objects from the bbmle package.
}
\examples{

if (require("bbmle", quietly = TRUE)) {
  x <- 0:10
  y <- c(26, 17, 13, 12, 20, 5, 9, 8, 5, 4, 8)
  d <- data.frame(x,y)
  
  fit <- mle2(y ~ dpois(lambda = ymean),
              start = list(ymean = mean(y)), data = d)
  
  tidy(fit)
}

}
