% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-kmeans-tidiers.R
\name{tidy.kmeans}
\alias{tidy.kmeans}
\alias{kmeans_tidiers}
\title{Tidy a(n) kmeans object}
\usage{
\method{tidy}{kmeans}(x, col.names = paste0("x", 1:ncol(x$centers)), ...)
}
\arguments{
\item{x}{A \code{kmeans} object created by \code{\link[stats:kmeans]{stats::kmeans()}}.}

\item{col.names}{Dimension names. Defaults to \verb{x1, x2, ...}}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with one row per cluster, and columns:

\item{size}{Number of points in cluster}
\item{withinss}{The within-cluster sum of squares}
\item{cluster}{A factor describing the cluster from 1:k}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies cross models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
For examples, see the kmeans vignette.
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[stats:kmeans]{stats::kmeans()}}

Other kmeans tidiers: 
\code{\link{augment.kmeans}()},
\code{\link{glance.kmeans}()}
}
\concept{kmeans tidiers}
