% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-factanal-tidiers.R
\name{tidy.factanal}
\alias{tidy.factanal}
\alias{factanal_tidiers}
\title{Tidy a(n) factanal object}
\usage{
\method{tidy}{factanal}(x, ...)
}
\arguments{
\item{x}{A \code{factanal} object created by \code{\link[stats:factanal]{stats::factanal()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with one row for each variable used in the
analysis and columns:

\item{variable}{The variable being estimated in the factor analysis}
\item{uniqueness}{Proportion of residual, or unexplained variance}
\item{flX}{Factor loading of term on factor X. There will be as many
columns of this format as there were factors fitted.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies cross models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{

mod <- factanal(mtcars, 3, scores = "regression")

glance(mod)
tidy(mod)
augment(mod)
augment(mod, mtcars)

}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[stats:factanal]{stats::factanal()}}

Other factanal tidiers: 
\code{\link{augment.factanal}()},
\code{\link{glance.factanal}()}
}
\concept{factanal tidiers}
