% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgcv-tidiers.R
\name{tidy.gam}
\alias{tidy.gam}
\alias{mgcv_tidiers}
\alias{gam_tidiers}
\title{Tidy a(n) gam object}
\usage{
\method{tidy}{gam}(x, parametric = FALSE, conf.int = FALSE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{A \code{gam} object returned from a call to \code{\link[mgcv:gam]{mgcv::gam()}}.}

\item{parametric}{Logical indicating if parametric or smooth terms should
be tidied. Defaults to \code{FALSE}, meaning that smooth terms are tidied
by default.}

\item{conf.int}{Logical indicating whether or not to include a confidence
interval in the tidied output. Defaults to \code{FALSE}.}

\item{conf.level}{The confidence level to use for the confidence interval
if \code{conf.int = TRUE}. Must be strictly greater than 0 and less than 1.
Defaults to 0.95, which corresponds to a 95 percent confidence interval.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.level = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
When \code{parametric = FALSE} return columns \code{edf} and \code{ref.df} rather
than \code{estimate} and \code{std.error}.
}
\examples{

g <- mgcv::gam(mpg ~ s(hp) + am + qsec, data = mtcars)

tidy(g)
tidy(g, parametric = TRUE)
glance(g)
augment(g)
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[mgcv:gam]{mgcv::gam()}}

Other mgcv tidiers: 
\code{\link{glance.gam}()}
}
\concept{mgcv tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{estimate}{The estimated value of the regression term.}
  \item{p.value}{The two-sided p-value associated with the observed statistic.}
  \item{statistic}{The value of a T-statistic to use in a hypothesis that the regression term is non-zero.}
  \item{std.error}{The standard error of the regression term.}
  \item{term}{The name of the regression term.}
  \item{edf}{The effective degrees of freedom. Only reported when
    `parametric = FALSE`}
  \item{ref.df}{The reference degrees of freedom. Only reported when
    `parametric = FALSE`}

}
