% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpvalint.R
\name{tpvalint}
\alias{tpvalint}
\title{Hypothesis testing using the Student t Distribution with H0: lo <= mu <= hi}
\usage{
tpvalint(coefficients, hi, lo = -hi, se, df, log = FALSE)
}
\arguments{
\item{coefficients}{a vector}

\item{hi}{upper bound}

\item{lo}{lower bound}

\item{se}{standard error}

\item{df}{degrees of freedom}

\item{log}{the probability is in log-scale}
}
\description{
Hypothesis testing using the Student t Distribution with H0: lo <= mu <= hi
}
\examples{
x=seq(from=-30, to=30, length.out=100)

data=do.call(
  rbind
  , lapply(
    seq_len(10)
    , function(cutoff)
      rbind(
        data.frame(x, pval=tpvalint(x, lo=-cutoff, hi=cutoff, se=1, df=3), cutoff=cutoff)
        )
    )
  )

ggplot2::qplot(x, pval, data=data, color=as.factor(cutoff), linetype=as.factor(cutoff), geom='line')
}
\keyword{htest}
