% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR_utils.R
\name{set.wd}
\alias{set.wd}
\alias{set_wd}
\title{Set working directory to the path of currently opened file.}
\usage{
set.wd(path = NULL, ask = FALSE)

set_wd(path = NULL, ask = FALSE)
}
\arguments{
\item{path}{\code{NULL} (default) or a specific path.
Default is to extract the path of the currently opened file
(usually .R or .Rmd) using the \code{rstudioapi::getSourceEditorContext} function.}

\item{ask}{\code{TRUE} or \code{FALSE} (default).
If \code{TRUE}, you can select a folder with the prompt of a dialog.}
}
\value{
Invisibly return the path.
}
\description{
Set working directory to the path of currently opened file (usually an R script).
You can use this function in both \strong{.R/.Rmd files and R Console}.
\href{https://www.rstudio.com/products/rstudio/download/preview/}{RStudio}
(version >= 1.2) is required for running this function.
}
\section{Functions}{
\itemize{
\item \code{set.wd}: Main function

\item \code{set_wd}: The alias of \code{set.wd} (the same)
}}

\examples{
\dontrun{

  # RStudio (version >= 1.2) is required for running this function.
  set.wd()  # set working directory to the path of the currently opened file
  set.wd("~/")  # set working directory to the home path
  set.wd("../")  # set working directory to the parent path
  set.wd(ask=TRUE)  # select a folder with the prompt of a dialog
}

}
\seealso{
\code{\link[base:getwd]{setwd}}
}
