% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brxx_Cor.R
\name{brxx_Cor}
\alias{brxx_Cor}
\title{brxx_Cor: Bayesian Estimation of Reliability from Correlation}
\usage{
brxx_Cor(x, y, alpha, beta, iter, burn, seed, CI, S0, nu0, mu0, items)
}
\arguments{
\item{x}{First variable.}

\item{y}{Second variable.}

\item{alpha}{Prior true score variance (covariance between tests)}

\item{beta}{Prior error variance (product of standard deviations minus covariance)}

\item{iter}{Number of iterations for the Gibbs sampler.}

\item{burn}{Number of samples to burn in.}

\item{seed}{Seed for the Gibbs sampler}

\item{CI}{Credible interval quantile, as a decimal (ie, for 95 percent, 0.95).}

\item{S0}{Prior variance covariance matrix.}

\item{nu0}{Prior degrees of freedom for inverse Wishart prior distribution.}

\item{mu0}{Prior means for each column.}

\item{items}{Number of test items.}
}
\value{
Returns median posterior estimates of the variance covariance matrix.
}
\description{
This function estimates reliability from a correlation
}
\examples{
set.seed(999)
your_data=mvrnorm(n=15,mu=c(0,0),Sigma=matrix(c(4,5,5,9),nrow=2,ncol=2))
x=your_data[,1]
y=your_data[,2]
Mu0=c(0,0)
Sigma0=matrix(c(1,0.6,0.6,4),nrow=2,ncol=2)
Nu0=3-1
brxx_Cor(x=x,y=y,iter=5000,burn=2500,seed=999,CI=0.95,
mu0=Mu0,S0=Sigma0,nu0=Nu0,items=10)

}
