% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feedbacks.R
\name{tooltip}
\alias{tooltip}
\alias{addTooltip}
\alias{removeTooltip}
\title{Create a Bootstrap 4 Tooltip from the UI side}
\usage{
tooltip(tag, title, placement = c("top", "bottom", "left", "right"))

addTooltip(
  id = NULL,
  selector = NULL,
  options,
  session = shiny::getDefaultReactiveDomain()
)

removeTooltip(id, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{tag}{Tooltip target.}

\item{title}{Tooltip title.}

\item{placement}{Tooltip placement: "top", "bottom", "left" or "right".}

\item{id}{Tooltip target id.}

\item{selector}{jQuery selector. Allow more customization for the target (nested tags).}

\item{options}{List of options to pass to the tooltip. See \url{https://getbootstrap.com/docs/4.0/components/tooltips/}.}

\item{session}{Shiny session object.}
}
\description{
This replaces the shinyBS tooltip feature that is not compatible
with Bootstrap 4

\link{addTooltip} adds a tooltip to the given target.

\link{removeTooltip} destroys the current targeted tooltip.
}
\note{
\link{tooltip} does not automatically handles tooltip removal and must be seperately implemented.
If the \link{dashboardHeader} help parameter is TRUE, all tooltips may be enabled
or disabled depending on the switch value, which may solve this problem.
This allows to toggle tooltips whenever required.

This replaces the shinyBS tooltip feature that is not compatible
with Bootstrap 4
}
\examples{
if (interactive()) {
  library(shiny)
  library(bs4Dash)

  shinyApp(
    ui = dashboardPage(
      header = dashboardHeader(),
      sidebar = dashboardSidebar(),
      controlbar = dashboardControlbar(),
      footer = dashboardFooter(),
      title = "Tooltip UI",
      body = dashboardBody(
        tooltip(
          actionButton("goButton", "Hover to see the tooltip"),
          title = "My tooltip",
          placement = "top"
        )
      )
    ),
    server = function(input, output) {}
  )
}
if (interactive()) {
  library(shiny)
  library(bs4Dash)

  shinyApp(
    ui = dashboardPage(
      header = dashboardHeader(),
      sidebar = dashboardSidebar(),
      controlbar = dashboardControlbar(),
      footer = dashboardFooter(),
      title = "Tooltip server",
      body = dashboardBody(
        sliderInput("obs", "Number of observations:",
          min = 0, max = 1000, value = 500
        ),
        plotOutput("distPlot")
      )
    ),
    server = function(input, output, session) {
      output$distPlot <- renderPlot({
        hist(rnorm(input$obs))
      })

      observeEvent(input$obs, {
        if (input$obs > 500) {
          addTooltip(
            id = "distPlot",
            options = list(
              title = "Server tooltip",
              placement = "bottom"
            )
          )
        } else {
          removeTooltip(id = "distPlot")
        }
      })
    }
  )
}
}
