% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bs_img}
\alias{bs_img}
\title{Create HTML img tag configured with Bootstrap classes}
\usage{
bs_img(
  src,
  alt = NULL,
  fluid = TRUE,
  thumbnail = FALSE,
  rounded = FALSE,
  float_start = FALSE,
  float_end = FALSE,
  center = FALSE,
  custom_class = NULL
)
}
\arguments{
\item{src}{A string, the value to pass to the "src" param of html5::img().}

\item{alt}{A string, the value to pass to the "alt" param of html5::img().}

\item{fluid}{TRUE/FALSE, if TRUE, adds the class "img-fluid".}

\item{thumbnail}{TRUE/FALSE, if TRUE (and fluid is FALSE), adds the class "img-thumbnail".}

\item{rounded}{TRUE/FALSE, if TRUE, adds the class "rounded".}

\item{float_start}{TRUE/FALSE, if TRUE, adds the class "float-start".}

\item{float_end}{TRUE/FALSE, if TRUE (and float_start is FALSE), adds the class "float-end".}

\item{center}{TRUE/FALSE, if TRUE, wraps img tag in a div with class "text-center".}

\item{custom_class}{A string, a custom class to append to the img tag.}
}
\value{
A string of HTML.
}
\description{
Create HTML img tag configured with Bootstrap classes
}
\examples{
bs_img(
src = tempfile()
)
}
