% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sem.R
\name{sem}
\alias{sem}
\title{sem: The SEM Function}
\usage{
sem(
  data,
  blocks,
  paths,
  exogenous,
  signals,
  row_names = rownames(data),
  prior_specs = list(beta = c("normal(0,1)"), sigma2 = c("inv_gamma(2.1, 1.1)"), gamma0
    = c("normal(0,1)"), gamma = c("normal(0,1)"), tau2 = c("inv_gamma(2.1, 1.1)")),
  cores = parallel::detectCores(),
  pars = c("alpha", "lambda", "sigma2"),
  iter = 2000,
  chains = 4,
  scaled = FALSE,
  verbose = FALSE,
  refresh = 100,
  ...
)
}
\arguments{
\item{data}{a mandatory 'matrix' object where the columns are variables and the rows are observations}

\item{blocks}{a mandatory named list of colnames (or integers in 1:ncol(data)) indicating the manisfest variables corresponding to each block; generic names are assumed for latent variables internally if not defined}

\item{paths}{list referring to the inner model paths; a list of characters or integers referring to the scores relationship; the jth first latent variable are explained if names(paths) is NULL}

\item{exogenous}{list referring to the inner model exogenous; a list of characters or integers referring to relationship between exogenous and latent variables; the lth first columns are explained if names(exogenous) is NULL}

\item{signals}{list referring to the signals of the factor loadings initial values; must be true: (length(signals) == length(blocks)) && (lengths(signals) == lengths(blocks)); (not allowed in runShiny)}

\item{row_names}{optional identifier for the observations (observation = row)}

\item{prior_specs}{prior settings for the Bayesian approach; only `normal` and `cauchy` for gamma0, gamma and beta; `gamma`, `lognormal` and `inv_gamma` for sigma2 and tau2 are available, those prior specifications are ignored if not needed (FA or SEM)}

\item{cores}{number of core threads to be used}

\item{pars}{allows parameters to omitted in the outcome; options are any subset of default c("alpha", "lambda", "sigma2")}

\item{iter}{number of iterations}

\item{chains}{number of chains}

\item{scaled}{logical; indicates whether to center and scale the data; default FALSE}

\item{verbose}{logical; see \code{\link[rstan]{sampling}}; default FALSE}

\item{refresh}{defaults to 100; see \code{\link[rstan]{sampling}};}

\item{...}{further arguments passed to Stan such as warmup, adapt_delta and others, see \code{\link[rstan]{sampling}}.}
}
\value{
An object of class \code{bsem}; a list of 14 to 19:
\describe{
   \item{stanfit}{S4 object of class stanfit}
   \item{posterior}{the list of posterior draws separated by chains}
   \item{model}{character; pointer to pre-defined stan model}
   \item{mean_alpha}{matrix of factor loadings posterior means}
   \item{mean_lambda}{matrix of factor scores posterior means}
   \item{mean_sigma2}{vector of error variances posterior means}
   \item{mean_beta}{vector of regression coefficients posterior means}
   \item{mean_tau2}{vector of inner paths error variances posterior means}
   \item{mean_gamma}{vector of inner paths regression coefficients posterior means}
   \item{mean_gamma0}{vector of inner paths intercept posterior means}
   \item{stats}{posterior descriptives statistics}
   \item{blocks}{list of blocks}
   \item{paths}{list of paths}
   \item{credint}{Highest posterior density intervals (HPD)}
   \item{h}{vector of posterior communalities}
   \item{PTVE}{vector of total variance proportions}
   \item{R2}{adjusted coefficient of determination}
   \item{SQE}{explained sums of squares}
   \item{SQT}{total sums of squares}
}
}
\description{
Structural Equation Models (SEM) and particular cases using rstan interface
}
\details{
Fits the SEM to specific data



Consider:

- the outer model as:
-- outer blocks:

 \deqn{X_{p x n} = \alpha_{p x k}\lambda_{k x n} + \epsilon_{p x n}}
   where \eqn{X} is the data matrix with variables in the rows and sample elements in the columns,  \eqn{\alpha_{p x j}} is the column vector of loadings for the \eqn{jth} latent variable and \eqn{\lambda_{j x n}} is the row vector of scores for the  \eqn{jth} unobserved variable, \eqn{j =1,\dots,k}. Normality is assumed for the errors as \eqn{\epsilon_{ij}~ N(0, \sigma_i ^2)} for \eqn{i = 1,\dots, p}.

   - the inner model as:

   -- inner paths:
     \deqn{\lambda_{j x n} = \beta \lambda^(-j)  + \nu}
       where \eqn{\beta} is a column vector of constant coefficients and \eqn{\lambda^(-j)_{ (k-1) x n}} represents a subset of the matrix of scores, i.e. at least excluding the \eqn{jth} row scores. The error assumes \eqn{\nu_j ~ N(0,1)}.

   -- inner exogenous:
       \deqn{Y_{l x n} = \gamma_0 + \gamma \lambda  + \xi}
         where \eqn{\gamma} is a column vector of constant coefficients and \eqn{\gamma_0} is the intercept. \eqn{\lambda_{k x n}} is the matrix of scores and the error assumes \eqn{\xi_l~ N(0,\tau_l^2)}.
}
\examples{
dt <- bsem::simdata()
names(dt)
\donttest{
semfit <- bsem::sem(
  data = dt$data,
  blocks = dt$blocks,
  paths = dt$paths,
  exogenous = dt$exogenous,
  signals = dt$signals,
  cores = 1
)
summary(semfit)
}
}
\seealso{
\code{\link[bsem]{plot.bsem}}, \code{\link[bsem]{simdata}}, \code{\link[bsem]{arrayplot}}, \code{\link[bsem]{summary.bsem}}, \code{\link[bsem]{print.bsem}}
}
\author{
Renato Panaro
}
