% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bspline.R
\name{iknots}
\alias{iknots}
\title{Estimate internal knot positions equalizing jumps in n-th derivative}
\usage{
iknots(x, y, nki = 1L, n = 3L, lenfit = 12L)
}
\arguments{
\item{x}{Numeric vector}

\item{y}{Numeric vector or matrix}

\item{nki}{Integer scalar, number of internal knots to estimate (1 by default)}

\item{n}{Integer scalar, polynomial order of B-spline (3 by default)}

\item{lenfit}{Integer scalar, length of knots for linear spline to fit the total variation)}
}
\value{
Numeric vector, estimated knot positions
}
\description{
Normalized total variation of n-th finite differences is calculated for each column in
\code{y} then averaged. These averaged values are fitted by a linear spline to
find knot positions that equalize the jumps of n-th derivative.\cr
NB. This function is used internally in \code{(fit)smbsp()} and a priori
has no interest to be called directly by user.
}
