% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bsc}
\alias{bsc}
\title{Basis matrix and knot Jacobian for B-spline of order 0 (step function) and higher}
\usage{
bsc(x, xk, n = 3L, cjac = FALSE)
}
\arguments{
\item{x}{Numeric vector, abscissa points}

\item{xk}{Numeric vector, knots}

\item{n}{Integer scalar, polynomial order (3 by default)}

\item{cjac}{Logical scalar, if \code{TRUE} makes to calculate Jacobian of basis
vectors as function of knot positions (FALSE by default)}
}
\value{
Numeric matrix (for cjac=FALSE), each column correspond to a
  B-spline calculated on x; or List (for cjac=TRUE) with components \describe{
     \item{mat}{basis matrix of dimension \code{nx x nw}, where nx is the length
       of x and \code{nw=nk-n-1} is the number of basis vectors}
     \item{jac}{array of dimension \code{nx x (n+2) x nw} where n+2
       is the number of support knots for each basis vector
   }
}
}
\description{
This function is analogous but not equivalent to \code{splines:bs()} and \code{splines2::bSpline()}.
It is also several times faster.
}
\details{
For n==0, step function is defined as constant on each interval
  \code{[xk[i]; xk[i+1][}, i.e. closed on the left and open on the right
  except for the last interval which is closed on the right too. The
  Jacobian for step function is considered 0 in every x point even if
  in points where x=xk, the derivative is not defined.\cr
  For n==1, Jacobian is discontinuous in such points so for
  these points we take the derivative from the right.
}
\examples{
  x=seq(0, 5, length.out=101)
  # cubic basis matrix
  n=3
  m=bsc(x, xk=c(rep(0, n+1), 1:4, rep(5, n+1)), n=n)
  matplot(x, m, t="l")
  stopifnot(all.equal.numeric(c(m), c(splines::bs(x, knots = 1:4, degree = n, intercept = TRUE))))
}
\seealso{
[splines::bs()], [splines2::bSpline()]
}
