% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/41_set_options.R
\name{set_SAR}
\alias{set_SAR}
\alias{set_SLX}
\alias{set_SEM}
\title{Set up a spatial prior}
\usage{
set_SAR(
  lambda_a = 1.01,
  lambda_b = 1.01,
  lambda = 0,
  lambda_scale = 0.1,
  lambda_min = -1,
  lambda_max = 1 - 1e-12,
  delta_a = 1.01,
  delta_b = 1.01,
  delta = 1,
  delta_scale = 0,
  delta_min = 1e-12,
  delta_max = Inf
)

set_SLX(
  lambda_a = 1.01,
  lambda_b = 1.01,
  lambda = 0,
  lambda_scale = 0.1,
  lambda_min = -1,
  lambda_max = 1 - 1e-12,
  delta_a = 1.01,
  delta_b = 1.01,
  delta = 1,
  delta_scale = 0,
  delta_min = 1e-12,
  delta_max = Inf
)

set_SEM(
  lambda_a = 1.01,
  lambda_b = 1.01,
  lambda = 0,
  lambda_scale = 0.1,
  lambda_min = -1,
  lambda_max = 1 - 1e-12,
  delta_a = 1.01,
  delta_b = 1.01,
  delta = 1,
  delta_scale = 0,
  delta_min = 1e-12,
  delta_max = Inf
)
}
\arguments{
\item{lambda_a, lambda_b}{Numeric scalars with the prior shapes of the connectivity strength 'lambda'.}

\item{lambda, delta}{Numerics with starting values for the respective parameter.}

\item{lambda_scale}{Numeric scalar with the proposal scale of 'lambda'.}

\item{lambda_min, lambda_max}{Numeric scalars with upper and lower bounds for 'lambda'.}

\item{delta_a, delta_b}{Numeric scalars with the prior shapes of the connectivity parameter 'delta'.}

\item{delta_scale}{Numeric scalar with the proposal scale of 'delta'. Defaults to zero for a fixed value.}

\item{delta_min, delta_max}{Numeric scalars with upper and lower bounds for 'delta'.}
}
\value{
Returns a list with priors and settings.
}
\description{
Set up a spatial prior
}
