% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/particle_smoother.R
\name{particle_smoother}
\alias{particle_smoother}
\alias{particle_smoother.gssm}
\alias{particle_smoother.ngssm}
\alias{particle_smoother.nlg_ssm}
\title{Particle Smoothing}
\usage{
particle_smoother(object, nsim, ...)

\method{particle_smoother}{gssm}(object, nsim, filter_type = "bsf",
  smoothing_method = "fs", seed = sample(.Machine$integer.max, size = 1),
  optimal = TRUE, ...)

\method{particle_smoother}{ngssm}(object, nsim, filter_type = "bsf",
  smoothing_method = "fs", seed = sample(.Machine$integer.max, size = 1),
  max_iter = 100, conv_tol = 1e-08, ...)

\method{particle_smoother}{nlg_ssm}(object, nsim, filter_type = "psi",
  smoothing_method = "fs", seed = sample(.Machine$integer.max, size = 1),
  max_iter = 100, conv_tol = 1e-08, iekf_iter = 0, ...)
}
\arguments{
\item{object}{Model.}

\item{nsim}{Number of samples.}

\item{...}{Ignored.}

\item{filter_type}{Choice of particle filter algorithm. For Gaussian models, 
possible choices are \code{"bsf"} (bootstrap particle filter) and 
\code{"apf"} (auxiliary particle filter). In addition, for non-Gaussian or 
non-linear models, \code{"psi"} uses psi-particle filter, and 
for non-linear models options \code{"ekf"} (extended Kalman particle filter) 
is also available.}

\item{smoothing_method}{Either \code{"fs"} (filter-smoother), or \code{"fbs"} 
(forward-backward smoother).}

\item{seed}{Seed for RNG.}

\item{optimal}{For Gaussian models, use optimal auxiliary particle filter? 
Default is \code{TRUE}.}

\item{max_iter}{Maximum number of iterations used in Gaussian approximation. Used psi-PF.}

\item{conv_tol}{Tolerance parameter used in Gaussian approximation. Used psi-PF.}

\item{iekf_iter}{If zero (default), first approximation for non-linear 
Gaussian models is obtained from extended Kalman filter. If 
\code{iekf_iter > 0}, iterated extended Kalman filter is used with 
\code{iekf_iter} iterations.}
}
\description{
Function \code{particle_smoother} performs filter-smoother or forward-backward smoother,
using a either bootstrap filtering or psi-auxiliary filter with stratification resampling.
}
