% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{svm}
\alias{svm}
\title{Stochastic Volatility Model}
\usage{
svm(y, rho, sd_ar, sigma, mu)
}
\arguments{
\item{y}{Vector or a \code{\link{ts}} object of observations.}

\item{rho}{prior for autoregressive coefficient.}

\item{sd_ar}{Prior for the standard deviation of noise of the AR-process.}

\item{sigma}{Prior for sigma parameter of observation equation.}

\item{mu}{Prior for mu parameter of transition equation.
Ignored if \code{sigma} is provided.}
}
\value{
Object of class \code{svm} or \code{svm2}.
}
\description{
Constructs a simple stochastic volatility model with Gaussian errors and
first order autoregressive signal.
}
\examples{

data("exchange")
model <- svm(exchange, rho = uniform(0.98,-0.999,0.999),
 sd_ar = halfnormal(0.15, 5), sigma = halfnormal(0.6, 2))

obj <- function(pars) {
   -logLik(svm(exchange, rho = uniform(pars[1],-0.999,0.999),
   sd_ar = halfnormal(pars[2],sd=5),
   sigma = halfnormal(pars[3],sd=2)), nsim_states = 0)
}
opt <- nlminb(c(0.98, 0.15, 0.6), obj, lower = c(-0.999, 1e-4, 1e-4), upper = c(0.999,10,10))
pars <- opt$par
model <- svm(exchange, rho = uniform(pars[1],-0.999,0.999),
  sd_ar = halfnormal(pars[2],sd=5),
  sigma = halfnormal(pars[3],sd=2))

}
