% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importance_sample.R
\name{importance_sample}
\alias{importance_sample}
\alias{importance_sample.ngssm}
\alias{importance_sample.ng_bsm}
\alias{importance_sample.svm}
\alias{importance_sample.ung_ar1}
\title{Importance Sampling from non-Gaussian State Space Model}
\usage{
importance_sample(object, nsim, use_antithetic, max_iter, conv_tol, seed,
  ...)

\method{importance_sample}{ngssm}(object, nsim, use_antithetic = TRUE,
  max_iter = 100, conv_tol = 1e-08,
  seed = sample(.Machine$integer.max, size = 1), ...)

\method{importance_sample}{ng_bsm}(object, nsim, use_antithetic = TRUE,
  max_iter = 100, conv_tol = 1e-08,
  seed = sample(.Machine$integer.max, size = 1), ...)

\method{importance_sample}{svm}(object, nsim, use_antithetic = TRUE,
  max_iter = 100, conv_tol = 1e-08,
  seed = sample(.Machine$integer.max, size = 1), ...)

\method{importance_sample}{ung_ar1}(object, nsim, use_antithetic = TRUE,
  max_iter = 100, conv_tol = 1e-08,
  seed = sample(.Machine$integer.max, size = 1), ...)
}
\arguments{
\item{object}{of class \code{ng_bsm}, \code{svm} or \code{ngssm}.}

\item{nsim}{Number of samples.}

\item{use_antithetic}{Logical. If \code{TRUE} (default), use antithetic 
variable for location in simulation smoothing.}

\item{max_iter}{Maximum number of iterations used for the approximation.}

\item{conv_tol}{Convergence threshold for the approximation. Approximation is 
claimed to be converged when the mean squared difference of the modes is 
less than \code{conv_tol}.}

\item{seed}{Seed for the random number generator.}

\item{...}{Ignored.}
}
\description{
Returns \code{nsim} samples from the approximating Gaussian model with corresponding
(scaled) importance weights.
}
