% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_mcmc.R
\name{run_mcmc.nongaussian}
\alias{run_mcmc.nongaussian}
\title{Bayesian Inference of Non-Gaussian State Space Models}
\usage{
\method{run_mcmc}{nongaussian}(
  model,
  iter,
  nsim,
  output_type = "full",
  mcmc_type = "da",
  sampling_method = "psi",
  burnin = floor(iter/2),
  thin = 1,
  gamma = 2/3,
  target_acceptance = 0.234,
  S,
  end_adaptive_phase = TRUE,
  local_approx = TRUE,
  n_threads = 1,
  seed = sample(.Machine$integer.max, size = 1),
  max_iter = 100,
  conv_tol = 1e-08,
  ...
)
}
\arguments{
\item{model}{Model model.}

\item{iter}{Number of MCMC iterations.}

\item{nsim}{Number of state samples per MCMC iteration.
Ignored if \code{mcmc_type} is \code{"approx"}.}

\item{output_type}{Either \code{"full"} 
(default, returns posterior samples of states alpha and hyperparameters theta), 
\code{"theta"} (for marginal posterior of theta), 
or \code{"summary"} (return the mean and variance estimates of the states 
and posterior samples of theta).}

\item{mcmc_type}{What MCMC algorithm to use? Possible choices are
\code{"pm"} for pseudo-marginal MCMC,
\code{"da"} for delayed acceptance version of PMCMC (default), 
\code{"approx"} for approximate inference based on the Gaussian approximation of the model,
or one of the three importance sampling type weighting schemes:
\code{"is3"} for simple importance sampling (weight is computed for each MCMC iteration independently),
\code{"is2"} for jump chain importance sampling type weighting, or
\code{"is1"} for importance sampling type weighting where the number of particles used for
weight computations is proportional to the length of the jump chain block.}

\item{sampling_method}{If \code{"psi"}, \eqn{\psi}{psi}-auxiliary particle filter is used for state sampling
(default). If \code{"spdk"}, non-sequential importance sampling based
on Gaussian approximation is used. If \code{"bsf"}, bootstrap filter
is used.}

\item{burnin}{Length of the burn-in period which is disregarded from the
results. Defaults to \code{iter / 2}.}

\item{thin}{Thinning rate. Defaults to 1. Increase for large models in
order to save memory. For IS-corrected methods, larger
value can also be statistically more effective. 
Note: With \code{output_type = "summary"}, the thinning does not affect the computations 
of the summary statistics in case of pseudo-marginal methods.}

\item{gamma}{Tuning parameter for the adaptation of RAM algorithm. Must be
between 0 and 1 (not checked).}

\item{target_acceptance}{Target acceptance ratio for RAM. Defaults to 0.234.}

\item{S}{Initial value for the lower triangular matrix of RAM
algorithm, so that the covariance matrix of the Gaussian proposal
distribution is \eqn{SS'}. Note that for some parameters 
(currently the standard deviation and dispersion parameters of bsm_ng models) the sampling
is done for transformed parameters with internal_theta = log(theta).}

\item{end_adaptive_phase}{If \code{TRUE} (default), $S$ is held fixed after the burnin period.}

\item{local_approx}{If \code{TRUE} (default), Gaussian approximation needed for
importance sampling is performed at each iteration. If false, approximation is updated only
once at the start of the MCMC.}

\item{n_threads}{Number of threads for state simulation.}

\item{seed}{Seed for the random number generator.}

\item{max_iter}{Maximum number of iterations used in Gaussian approximation.}

\item{conv_tol}{Tolerance parameter used in Gaussian approximation.}

\item{...}{Ignored.
set.seed(1)
n <- 50 
slope <- cumsum(c(0, rnorm(n - 1, sd = 0.001)))
level <- cumsum(slope + c(0, rnorm(n - 1, sd = 0.2)))
y <- rpois(n, exp(level))
poisson_model <- bsm_ng(y, 
  sd_level = halfnormal(0.01, 1), 
  sd_slope = halfnormal(0.01, 0.1), 
  P1 = diag(c(10, 0.1)), distribution = "poisson")
mcmc_is <- run_mcmc(poisson_model, iter = 1000, nsim = 10, mcmc_type = "is2")
summary(mcmc_is, what = "theta", return_se = TRUE)}
}
\description{
Methods for posterior inference of states and parameters.
}
