% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_filter.R
\name{bootstrap_filter}
\alias{bootstrap_filter}
\alias{bootstrap_filter.gaussian}
\alias{bootstrap_filter.nongaussian}
\alias{bootstrap_filter.ssm_nlg}
\alias{bootstrap_filter.ssm_sde}
\title{Bootstrap Filtering}
\usage{
bootstrap_filter(model, nsim, ...)

\method{bootstrap_filter}{gaussian}(
  model,
  nsim,
  seed = sample(.Machine$integer.max, size = 1),
  ...
)

\method{bootstrap_filter}{nongaussian}(
  model,
  nsim,
  seed = sample(.Machine$integer.max, size = 1),
  ...
)

\method{bootstrap_filter}{ssm_nlg}(
  model,
  nsim,
  seed = sample(.Machine$integer.max, size = 1),
  ...
)

\method{bootstrap_filter}{ssm_sde}(
  model,
  nsim,
  L,
  seed = sample(.Machine$integer.max, size = 1),
  ...
)
}
\arguments{
\item{model}{of class \code{bsm_lg}, \code{bsm_ng} or \code{svm}.}

\item{nsim}{Number of samples.}

\item{...}{Ignored.}

\item{seed}{Seed for RNG.}

\item{L}{Integer defining the discretization level for SDE models.}
}
\value{
A list containing samples, weights from the last time point, and an
estimate of log-likelihood.
}
\description{
Function \code{bootstrap_filter} performs a bootstrap filtering with stratification
resampling.
}
\examples{
set.seed(1)
x <- cumsum(rnorm(50))
y <- rnorm(50, x, 0.5) 
model <- bsm_lg(y, sd_y = 0.5, sd_level = 1, P1 = 1)
  
out <- bootstrap_filter(model, nsim = 1000)
ts.plot(cbind(y, x, out$att), col = 1:3)
ts.plot(cbind(kfilter(model)$att, out$att), col = 1:3)

data("poisson_series")
model <- bsm_ng(poisson_series, sd_level = 0.1, sd_slope = 0.01, 
  P1 = diag(1, 2), distribution = "poisson")
  
out <- bootstrap_filter(model, nsim = 100)
ts.plot(cbind(poisson_series, exp(out$att[, 1])), col = 1:2)

}
\references{
Gordon, N. J., Salmond, D. J., & Smith, A. F. M. (1993). 
Novel approach to nonlinear/non-Gaussian Bayesian state estimation. IEE Proceedings-F, 140, 107–113.
}
