% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglik.R
\name{logLik.ssm_nlg}
\alias{logLik.ssm_nlg}
\title{Log-likelihood of a Non-linear State Space Model}
\usage{
\method{logLik}{ssm_nlg}(
  object,
  particles,
  method = "bsf",
  max_iter = 100,
  conv_tol = 1e-08,
  iekf_iter = 0,
  seed = sample(.Machine$integer.max, size = 1),
  ...
)
}
\arguments{
\item{object}{Model model.}

\item{particles}{Number of samples for particle filter. If 0, 
approximate log-likelihood is returned either based on the Gaussian approximation or EKF, 
depending on the \code{method} argument.}

\item{method}{Sampling method. Default is the bootstrap particle filter (\code{"bsf"}). 
Other choices are \code{"psi"} which uses psi-auxiliary filter 
(or approximating Gaussian model in the case of \code{particles = 0}), and \code{"ekf"} which 
uses EKF-based particle filter (or just EKF approximation in the case of \code{particles = 0}).}

\item{max_iter}{Maximum number of iterations for gaussian approximation algorithm.}

\item{conv_tol}{Tolerance parameter for the approximation algorithm.}

\item{iekf_iter}{If \code{iekf_iter > 0}, iterated extended Kalman filter is used with
\code{iekf_iter} iterations in place of standard EKF. Defaults to zero.}

\item{seed}{Seed for the random number generator.}

\item{...}{Ignored.}
}
\description{
Computes the log-likelihood of a state space model of class \code{ssm_nlg} package.
}
