% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.R
\name{fitted.mcmc_output}
\alias{fitted.mcmc_output}
\title{Fitted for State Space Model}
\usage{
\method{fitted}{mcmc_output}(object, model, probs = c(0.025, 0.975), ...)
}
\arguments{
\item{object}{Results object of class \code{mcmc_output} from
\code{\link{run_mcmc}} based on the input model.}

\item{model}{A \code{bssm_model} object.}

\item{probs}{Numeric vector defining the quantiles of interest. Default is
\code{c(0.025, 0.975)}.}

\item{...}{Ignored.}
}
\description{
Returns summary statistics from the posterior predictive
distribution of the mean.
}
\examples{
prior <- uniform(0.1 * sd(log10(UKgas)), 0, 1)
model <- bsm_lg(log10(UKgas), sd_y = prior, sd_level =  prior,
  sd_slope =  prior, sd_seasonal =  prior, period = 4)
fit <- run_mcmc(model, iter = 1e4)
res <- fitted(fit, model) 
head(res)

}
