% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_fitted_values.R
\name{compute_fitted_values.PosteriorBSVARMIX}
\alias{compute_fitted_values.PosteriorBSVARMIX}
\title{Computes posterior draws from data predictive density}
\usage{
\method{compute_fitted_values}{PosteriorBSVARMIX}(posterior)
}
\arguments{
\item{posterior}{posterior estimation outcome - an object of class 
\code{PosteriorBSVARMIX} obtained by running the \code{estimate} function.}
}
\value{
An object of class \code{PosteriorFitted}, that is, an \code{NxTxS} 
array with attribute \code{PosteriorFitted} containing \code{S} draws from 
the data predictive density.
}
\description{
Each of the draws from the posterior estimation of models from 
packages \pkg{bsvars} or \pkg{bsvarSIGNs} is transformed into
a draw from the data predictive density.
}
\examples{
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
set.seed(123)
specification  = specify_bsvar_mix$new(us_fiscal_lsuw, p = 1, M = 2)

# run the burn-in
burn_in        = estimate(specification, 10)

# estimate the model
posterior      = estimate(burn_in, 20)

# compute draws from in-sample predictive density
csd     = compute_fitted_values(posterior)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar_mix$new(p = 1, M = 2) |>
  estimate(S = 10) |> 
  estimate(S = 20) |> 
  compute_fitted_values() -> csd
  
}
\seealso{
\code{\link{estimate}}, \code{\link{summary}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
