% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_bsvar_t.R
\name{specify_prior_bsvar_t}
\alias{specify_prior_bsvar_t}
\title{R6 Class Representing PriorBSVART}
\description{
The class PriorBSVART presents a prior specification for the bsvar model with
t-distributed structural shocks.
}
\examples{
prior = specify_prior_bsvar_t$new(N = 3, p = 1)  # specify the prior
prior$A                                        # show autoregressive prior mean

}
\section{Super class}{
\code{bsvars::PriorBSVAR} -> \code{PriorBSVART}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{A}}{an \code{NxK} matrix, the mean of the normal prior distribution 
for the parameter matrix \eqn{A}.}

\item{\code{A_V_inv}}{a \code{KxK} precision matrix of the normal prior 
distribution for each of the row of the parameter matrix \eqn{A}. This 
precision matrix is equation invariant.}

\item{\code{B_V_inv}}{an \code{NxN} precision matrix of the generalised-normal 
prior distribution for the structural matrix \eqn{B}. This precision 
matrix is equation invariant.}

\item{\code{B_nu}}{a positive integer greater of equal than \code{N}, a shape 
parameter of the generalised-normal prior distribution for the structural
 matrix \eqn{B}.}

\item{\code{hyper_nu_B}}{a positive scalar, the shape parameter of the inverted-gamma 2 prior
for the overall shrinkage parameter for matrix \eqn{B}.}

\item{\code{hyper_a_B}}{a positive scalar, the shape parameter of the gamma prior
for the second-level hierarchy for the overall shrinkage parameter for matrix \eqn{B}.}

\item{\code{hyper_s_BB}}{a positive scalar, the scale parameter of the inverted-gamma 2 prior
for the third-level of hierarchy for overall shrinkage parameter for matrix \eqn{B}.}

\item{\code{hyper_nu_BB}}{a positive scalar, the shape parameter of the inverted-gamma 2 prior
for the third-level of hierarchy for overall shrinkage parameter for matrix \eqn{B}.}

\item{\code{hyper_nu_A}}{a positive scalar, the shape parameter of the inverted-gamma 2 prior 
for the overall shrinkage parameter for matrix \eqn{A}.}

\item{\code{hyper_a_A}}{a positive scalar, the shape parameter of the gamma prior
for the second-level hierarchy for the overall shrinkage parameter for matrix \eqn{A}.}

\item{\code{hyper_s_AA}}{a positive scalar, the scale parameter of the inverted-gamma 2 prior
for the third-level of hierarchy for overall shrinkage parameter for matrix \eqn{A}.}

\item{\code{hyper_nu_AA}}{a positive scalar, the shape parameter of the inverted-gamma 2 prior
for the third-level of hierarchy for overall shrinkage parameter for matrix \eqn{A}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PriorBSVART-clone}{\code{specify_prior_bsvar_t$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bsvars" data-topic="PriorBSVAR" data-id="get_prior"><a href='../../bsvars/html/PriorBSVAR.html#method-PriorBSVAR-get_prior'><code>bsvars::PriorBSVAR$get_prior()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bsvars" data-topic="PriorBSVAR" data-id="initialize"><a href='../../bsvars/html/PriorBSVAR.html#method-PriorBSVAR-initialize'><code>bsvars::PriorBSVAR$initialize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PriorBSVART-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PriorBSVART-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_prior_bsvar_t$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
