% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildmer.R
\name{buildgamm4}
\alias{buildgamm4}
\title{Use \code{buildmer} to fit generalized additive models using package \code{gamm4}}
\usage{
buildgamm4(
  formula,
  data = NULL,
  family = gaussian(),
  cl = NULL,
  direction = c("order", "backward"),
  crit = "LRT",
  include = NULL,
  calc.anova = FALSE,
  calc.summary = TRUE,
  ddf = "Wald",
  ...
)
}
\arguments{
\item{formula}{See the general documentation under \code{\link{buildmer-package}}}

\item{data}{See the general documentation under \code{\link{buildmer-package}}}

\item{family}{See the general documentation under \code{\link{buildmer-package}}}

\item{cl}{See the general documentation under \code{\link{buildmer-package}}}

\item{direction}{See the general documentation under \code{\link{buildmer-package}}}

\item{crit}{See the general documentation under \code{\link{buildmer-package}}}

\item{include}{See the general documentation under \code{\link{buildmer-package}}}

\item{calc.anova}{See the general documentation under \code{\link{buildmer-package}}}

\item{calc.summary}{See the general documentation under \code{\link{buildmer-package}}}

\item{ddf}{The method used for calculating \emph{p}-values if all smooth terms were eliminated and \code{calc.anova=TRUE} or \code{calc.summary=TRUE}. Options are \code{'Wald'} (default), \code{'Satterthwaite'} (if package \code{lmerTest} is available), \code{'Kenward-Roger'} (if packages \code{lmerTest} and \code{pbkrtest} are available), and \code{'lme4'} (no \emph{p}-values)}

\item{...}{Additional options to be passed to \code{gamm4}}
}
\description{
Use \code{buildmer} to fit generalized additive models using package \code{gamm4}
}
\details{
The fixed and random effects are to be passed as a single formula in \emph{\code{lme4} format}. This is internally split up into the appropriate \code{fixed} and \code{random} parts.
}
\examples{
\dontshow{
library(buildmer)
if (requireNamespace('gamm4')) model <- buildgamm4(Reaction ~ Days + (Days|Subject),data=lme4::sleepstudy)
}
\donttest{
library(buildmer)
if (requireNamespace('gamm4')) model <- buildgamm4(f1 ~ s(timepoint,by=following) +
       s(participant,timepoint,by=following,bs='fs'),data=vowels)
}
}
\seealso{
\code{\link{buildmer-package}}
}
