% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patternFuns.R
\name{calculate_condition_mean_sd_per_gene}
\alias{calculate_condition_mean_sd_per_gene}
\title{Calculate statistics for each gene of an expression matrix given a grouping}
\usage{
calculate_condition_mean_sd_per_gene(expression.matrix, condition)
}
\arguments{
\item{expression.matrix}{the expression matrix; rows correspond to genes and
columns correspond to samples; usually preprocessed by
\code{\link{preprocessExpressionMatrix}}}

\item{condition}{the condition to group the columns of the expression matrix
by; must be a factor of the same length as ncol(expression.matrix)}
}
\value{
A tibble in long format, with the mean and standard deviation of
each gene in each condition. The standard deviation is increased to the
minimum value in the expression matrix (the noise threshold) if it is lower,
in order to avoid sensitivity to small changes.
}
\description{
This function calculates the mean and standard deviation of
the expression of each gene in an expression matrix, grouped by the conditions
supplied.
}
\examples{
expression.matrix.preproc <- as.matrix(read.csv(
  system.file("extdata", "expression_matrix_preprocessed.csv", package = "bulkAnalyseR"), 
  row.names = 1
))[1:500,]

condition <- factor(rep(c("0h", "12h", "36h"), each = 2))
tbl <- calculate_condition_mean_sd_per_gene(expression.matrix.preproc[1:10, ], condition)
tbl
}
