% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{autoplot.bumbldf}
\alias{autoplot.bumbldf}
\title{Plot observed and fitted results from bumbl()}
\usage{
\method{autoplot}{bumbldf}(x, colony = NULL)
}
\arguments{
\item{x}{a dataframe produced by \code{\link[=bumbl]{bumbl()}}}

\item{colony}{a character vector of colony IDs to plot}
}
\value{
invisibly returns a ggplot object
}
\description{
Plots observed (points) and fitted (red line) values from the model implemented by \code{bumbl()}, faceted by colony.
}
\examples{
bombus_subset <- bombus[bombus$colony \%in\% c("17", "104", "20", "24"), ]
results <- bumbl(bombus_subset, colonyID = colony, t = week,
                 formula = mass ~ week)
library(ggplot2)
autoplot(results)
}
