% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notch_equation.R
\name{notch_equation}
\alias{notch_equation}
\title{Notch Equation}
\usage{
notch_equation(e, t0, t1, zstar, dzstar)
}
\arguments{
\item{e}{elasticity.}

\item{t0}{numeric value setting the marginal (average) tax rate below zstar in a kink (notch) setting.}

\item{t1}{numeric value setting the marginal (average) tax rate above zstar in a kink (notch) setting.}

\item{zstar}{a numeric value for the the bunching point.}

\item{dzstar}{The distance of the marginal buncher from zstar.}
}
\value{
\code{util_diff} returns the difference in utility between zstar and z_I in notch setting.
}
\description{
Defines indifference condition based on parametric utility function in notch setting. Used to parametrically solve for elasticity.
}
\examples{
notch_equation(e = .04, t0 = 0, t1 = .2, zstar = 10000, dzstar = 50)
}
\seealso{
\code{\link{bunchit}}

\code{\link{elasticity}}
}
