% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multnet.R
\name{axe-multnet}
\alias{axe-multnet}
\alias{axe_call.multnet}
\title{Axing an multnet.}
\usage{
\method{axe_call}{multnet}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed multnet object.
}
\description{
multnet objects are created from carrying out multinomial regression
in the \pkg{glmnet} package.
}
\examples{
\donttest{
if (rlang::is_installed("glmnet")) {

# Load libraries
suppressWarnings(suppressMessages(library(parsnip)))

# Load data
set.seed(1234)
predictrs <- matrix(rnorm(100*20), ncol = 20)
colnames(predictrs) <- paste0("a", seq_len(ncol(predictrs)))
response <- as.factor(sample(1:4, 100, replace = TRUE))

# Create model and fit
multnet_fit <- multinom_reg(penalty = 0.1) \%>\%
  set_engine("glmnet") \%>\%
  fit_xy(x = predictrs, y = response)

out <- butcher(multnet_fit, verbose = TRUE)

}
}
}
