% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_vec.R
\name{gen_vec}
\alias{gen_vec}
\title{Vector Error Correction Model Input}
\usage{
gen_vec(
  data,
  p = 2,
  exogen = NULL,
  s = 2,
  r = NULL,
  const = NULL,
  trend = NULL,
  seasonal = NULL,
  structural = FALSE,
  tvp = FALSE,
  sv = FALSE,
  fcst = NULL,
  iterations = 50000,
  burnin = 5000
)
}
\arguments{
\item{data}{a time-series object of endogenous variables.}

\item{p}{an integer vector of the lag order of the series in the (levels) VAR. Thus, the
resulting model's lag will be \eqn{p - 1}. See 'Details'.}

\item{exogen}{an optional time-series object of external regressors.}

\item{s}{an optional integer vector of the lag order of the exogenous variables of the series
in the (levels) VAR. Thus, the resulting model's lag will be \eqn{s - 1}. See 'Details'.}

\item{r}{an integer vector of the cointegration rank. See 'Details'.}

\item{const}{a character specifying whether a constant term enters the error correction
term (\code{"restricted"}) or the non-cointegration term as an \code{"unrestricted"} variable.
If \code{NULL} (default) no constant term will be added.}

\item{trend}{a character specifying whether a trend term enters the error correction
term (\code{"restricted"}) or the non-cointegration term as an \code{"unrestricted"} variable.
If \code{NULL} (default) no constant term will be added.}

\item{seasonal}{a character specifying whether seasonal dummies should be included in the error
correction term (\code{"restricted"}) or in the non-cointegreation term as \code{"unrestricted"}
variables. If \code{NULL} (default) no seasonal terms will be added. The amount of dummy variables
will be automatically detected and depends on the frequency of the time-series object provided
in \code{data}.}

\item{structural}{logical indicating whether data should be prepared for the estimation of a
structural VAR model.}

\item{tvp}{logical indicating whether the model parameters are time varying.}

\item{sv}{logical indicating whether time varying error variances should be estimated by
employing a stochastic volatility algorithm.}

\item{fcst}{integer. Number of observations saved for forecasting evaluation.}

\item{iterations}{an integer of MCMC draws excluding burn-in draws (defaults
to 50000).}

\item{burnin}{an integer of MCMC draws used to initialize the sampler
(defaults to 5000). These draws do not enter the computation of posterior
moments, forecasts etc.}
}
\value{
An object of class \code{'bvecmodel'}, which contains the following elements:
\item{data}{A list of data objects, which can be used for posterior simulation. Element
\code{Y} is a time-series object of dependent variables. Element \code{W} is a timer-series
object of variables in the cointegration term and element \code{X} is a time-series
object of variables that do not enter the cointegration term. Element \code{SUR} contains a
matrix of element \code{X} in its SUR form.}
\item{model}{A list of model specifications.}
}
\description{
\code{gen_vec} produces the input for the estimation of a vector error correction (VEC) model.
}
\details{
The function produces the variable matrices of vector error correction (VEC)
models, which can also include exogenous variables:
\deqn{\Delta y_t = \Pi w_t + \sum_{i=1}^{p-1} \Gamma_{i} \Delta y_{t - i} + 
\sum_{i=0}^{s-1} \Upsilon_{i} \Delta x_{t - i} +
C^{UR} d^{UR}_t + u_t,}
where
\eqn{\Delta y_t} is a \eqn{K \times 1} vector of differenced endogenous variables,
\eqn{w_t} is a \eqn{(K + M + N^{R}) \times 1} vector of cointegration variables,
\eqn{\Pi} is a \eqn{K \times (K + M + N^{R})} matrix of cointegration parameters,
\eqn{\Gamma_i} is a \eqn{K \times K} coefficient matrix of endogenous variables,
\eqn{\Delta x_t} is a \eqn{M \times 1} vector of differenced exogenous regressors,
\eqn{\Upsilon_i} is a \eqn{K \times M} coefficient matrix of exogenous regressors,
\eqn{d^{UR}_t} is a \eqn{N \times 1} vector of deterministic terms, and
\eqn{C^{UR}} is a \eqn{K \times N^{UR}} coefficient matrix of deterministic terms
that do not enter the cointegration term.
\eqn{p} is the lag order of endogenous variables and \eqn{s} is the lag
order of exogenous variables of the corresponding VAR model.
\eqn{u_t} is a \eqn{K \times 1} error term.

If an integer vector is provided as argument \code{p}, \code{s} or \code{r}, the function will
produce a distinct model for all possible combinations of those specifications.

If \code{tvp} is \code{TRUE}, the respective coefficients
of the above model are assumed to be time varying. If \code{sv} is \code{TRUE},
the error covariance matrix is assumed to be time varying.
}
\examples{

# Load data
data("e6")

# Generate model data
data <- gen_vec(e6, p = 4, const = "unrestricted", season = "unrestricted")

}
\references{
Lütkepohl, H. (2006). \emph{New introduction to multiple time series analysis} (2nd ed.). Berlin: Springer.
}
