% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varlse.R, R/print-varlse.R
\name{var_lm}
\alias{var_lm}
\alias{print.varlse}
\alias{knit_print.varlse}
\title{Fitting Vector Autoregressive Model of Order p Model}
\usage{
var_lm(y, p = 1, include_mean = TRUE, method = c("nor", "chol", "qr"))

\method{print}{varlse}(x, digits = max(3L, getOption("digits") - 3L), ...)

knit_print.varlse(x, ...)
}
\arguments{
\item{y}{Time series data of which columns indicate the variables}

\item{p}{Lag of VAR (Default: 1)}

\item{include_mean}{Add constant term (Default: \code{TRUE}) or not (\code{FALSE})}

\item{method}{Method to solve linear equation system.
(\code{"nor"}: normal equation (default), \code{"chol"}: Cholesky, and \code{"qr"}: HouseholderQR)}

\item{x}{\code{varlse} object}

\item{digits}{digit option to print}

\item{...}{not used}
}
\value{
\code{var_lm()} returns an object named \code{varlse} \link{class}.
It is a list with the following components:

\describe{
\item{coefficients}{Coefficient Matrix}
\item{fitted.values}{Fitted response values}
\item{residuals}{Residuals}
\item{covmat}{LS estimate for covariance matrix}
\item{df}{Numer of Coefficients: mp + 1 or mp}
\item{p}{Lag of VAR}
\item{m}{Dimension of the data}
\item{obs}{Sample size used when training = \code{totobs} - \code{p}}
\item{totobs}{Total number of the observation}
\item{call}{Matched call}
\item{process}{Process: VAR}
\item{type}{include constant term (\code{"const"}) or not (\code{"none"})}
\item{y0}{\eqn{Y_0}}
\item{design}{\eqn{X_0}}
\item{y}{Raw input}
}
It is also a \code{bvharmod} class.
}
\description{
This function fits VAR(p) using OLS method.
}
\details{
This package specifies VAR(p) model as
\deqn{Y_{t} = A_1 Y_{t - 1} + \cdots + A_p Y_{t - p} + c + \epsilon_t}

If \code{include_type = TRUE}, there is \eqn{c} term.
Otherwise (\code{include_type = FALSE}), there is no \eqn{c} term.
The function estimates every coefficient matrix \eqn{A_1, \ldots, A_p, c}.
\itemize{
\item Response matrix, \eqn{Y_0} in \link{var_design_formulation}
\item Design matrix, \eqn{X_0} in \link{var_design_formulation}
\item Coefficient matrix is the form of \eqn{A = [A_1, A_2, \ldots, A_p, c]^T}.
}

Then perform least squares to the following multivariate regression model
\deqn{Y_0 = X_0 A + error}

which gives

\deqn{\hat{A} = (X_0^T X_0)^{-1} X_0^T Y_0}
}
\examples{
# Perform the function using etf_vix dataset
fit <- var_lm(y = etf_vix, p = 2)
class(fit)
str(fit)

# Extract coef, fitted values, and residuals
coef(fit)
head(residuals(fit))
head(fitted(fit))
}
\references{
Lütkepohl, H. (2007). \emph{New Introduction to Multiple Time Series Analysis}. Springer Publishing.
}
\seealso{
\itemize{
\item Other package \code{\link[vars:VAR]{vars::VAR()}} is famous in VAR modeling.
\item \code{\link[=coef.varlse]{coef.varlse()}}, \code{\link[=residuals.varlse]{residuals.varlse()}}, and \code{\link[=fitted.varlse]{fitted.varlse()}}
\item \code{\link[=summary.varlse]{summary.varlse()}} to summarize VAR model
\item \code{\link[=predict.varlse]{predict.varlse()}} to forecast the VAR process
\item \link{var_design_formulation} for the model design
}
}
