% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-forecast.R
\name{mrae}
\alias{mrae}
\alias{mrae.predbvhar}
\alias{mrae.bvharcv}
\title{Evaluate the Model Based on MRAE (Mean Relative Absolute Error)}
\usage{
mrae(x, pred_bench, y, ...)

\method{mrae}{predbvhar}(x, pred_bench, y, ...)

\method{mrae}{bvharcv}(x, pred_bench, y, ...)
}
\arguments{
\item{x}{Forecasting object to use}

\item{pred_bench}{The same forecasting object from benchmark model}

\item{y}{Test data to be compared. should be the same format with the train data.}

\item{...}{not used}
}
\value{
MRAE vector corresponding to each variable.
}
\description{
This function computes MRAE given prediction result versus evaluation set.
}
\details{
Let \eqn{e_t = y_t - \hat{y}_t}.
MRAE implements benchmark model as scaling method.
Relative error is defined by
\deqn{r_t = \frac{e_t}{e_t^{\ast}}}
where \eqn{e_t^\ast} is the error from the benchmark method.
Then

\deqn{MRAE = mean(\lvert r_t \rvert)}
}
\references{
Hyndman, R. J., & Koehler, A. B. (2006). \emph{Another look at measures of forecast accuracy}. International Journal of Forecasting, 22(4), 679–688.
}
