% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bvhar-sv.R, R/print-bvharsp.R
\name{bvhar_sv}
\alias{bvhar_sv}
\alias{print.bvharsv}
\alias{knit_print.bvharsv}
\title{Fitting Bayesian VHAR-SV}
\usage{
bvhar_sv(
  y,
  har = c(5, 22),
  num_iter = 1000,
  num_burn = floor(num_iter/2),
  thinning = 1,
  bayes_spec = set_bvhar(),
  include_mean = TRUE,
  minnesota = c("no", "short", "longrun"),
  verbose = FALSE,
  num_thread = 1
)

\method{print}{bvharsv}(x, digits = max(3L, getOption("digits") - 3L), ...)

knit_print.bvharsv(x, ...)
}
\arguments{
\item{y}{Time series data of which columns indicate the variables}

\item{har}{Numeric vector for weekly and monthly order. By default, \code{c(5, 22)}.}

\item{num_iter}{MCMC iteration number}

\item{num_burn}{Number of burn-in (warm-up). Half of the iteration is the default choice.}

\item{thinning}{Thinning every thinning-th iteration}

\item{bayes_spec}{A BVHAR model specification by \code{\link[=set_bvhar]{set_bvhar()}} (default) or \code{\link[=set_weight_bvhar]{set_weight_bvhar()}}.}

\item{include_mean}{Add constant term (Default: \code{TRUE}) or not (\code{FALSE})}

\item{minnesota}{Apply cross-variable shrinkage structure (Minnesota-way). Two type: \code{"short"} type and \code{"longrun"} type. By default, \code{"no"}.}

\item{verbose}{Print the progress bar in the console. By default, \code{FALSE}.}

\item{num_thread}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Number of threads}

\item{x}{\code{bvarsv} object}

\item{digits}{digit option to print}

\item{...}{not used}
}
\value{
\code{bvhar_sv()} returns an object named \code{bvharsv} \link{class}. It is a list with the following components:
\describe{
\item{phi_record}{MCMC trace for vectorized coefficients (phi \eqn{\phi}) with \link[posterior:draws_df]{posterior::draws_df} format.}
\item{h_record}{MCMC trace for log-volatilities.}
\item{a_record}{MCMC trace for contemporaneous coefficients.}
\item{h0_record}{MCMC trace for initial log-volatilities.}
\item{sigh_record}{MCMC trace for log-volatilities variance.}
\item{coefficients}{Posterior mean of coefficients.}
\item{chol_posterior}{Posterior mean of contemporaneous effects.}
\item{pip}{Posterior inclusion probabilities.}
\item{param}{Every set of MCMC trace.}
\item{group}{Indicators for group.}
\item{df}{Numer of Coefficients: \verb{3m + 1} or \verb{3m}}
\item{p}{3 (The number of terms. It contains this element for usage in other functions.)}
\item{week}{Order for weekly term}
\item{month}{Order for monthly term}
\item{m}{Dimension of the data}
\item{obs}{Sample size used when training = \code{totobs} - \code{p}}
\item{totobs}{Total number of the observation}
\item{call}{Matched call}
\item{process}{Description of the model, e.g. \verb{"VHAR_SSVS_SV", }"VHAR_Horseshoe_SV", or \verb{"VHAR_minnesota-part_SV"\} \\item\{type\}\{include constant term (}"const"\verb{) or not (}"none"`)}
\item{spec}{SSVS specification defined by \code{\link[=set_ssvs]{set_ssvs()}}}
\item{init}{Initial specification defined by \code{\link[=init_ssvs]{init_ssvs()}}}
\item{iter}{Total iterations}
\item{burn}{Burn-in}
\item{thin}{Thinning}
\item{chain}{The numer of chains}
\item{HARtrans}{VHAR linear transformation matrix}
\item{y0}{\eqn{Y_0}}
\item{design}{\eqn{X_0}}
\item{y}{Raw input}
}
Different members are added according to priors. If it is SSVS:
\describe{
\item{gamma_record}{MCMC trace for dummy variable.}
}
Horseshoe:
\describe{
\item{lambda_record}{MCMC trace for local shrinkage level.}
\item{tau_record}{MCMC trace for global shrinkage level.}
\item{kappa_record}{MCMC trace for shrinkage factor.}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} This function fits VHAR-SV.
It can have Minnesota, SSVS, and Horseshoe prior.
}
\details{
Cholesky stochastic volatility modeling for VHAR based on
\deqn{\Sigma_t = L^T D_t^{-1} L}
}
\references{
Kim, Y. G., and Baek, C. (2023+). \emph{Bayesian vector heterogeneous autoregressive modeling}. Journal of Statistical Computation and Simulation.

Kim, Y. G., and Baek, C. (n.d.). Working paper.
}
