% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bvhar-minnesota.R, R/print-bvharmn.R
\name{bvhar_minnesota}
\alias{bvhar_minnesota}
\alias{print.bvharmn}
\alias{knit_print.bvharmn}
\title{Fitting Bayesian VHAR of Minnesota Prior}
\usage{
bvhar_minnesota(
  y,
  har = c(5, 22),
  bayes_spec = set_bvhar(),
  include_mean = TRUE
)

\method{print}{bvharmn}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{knit_print}{bvharmn}(x, ...)
}
\arguments{
\item{y}{Time series data of which columns indicate the variables}

\item{har}{Numeric vector for weekly and monthly order. By default, \code{c(5, 22)}.}

\item{bayes_spec}{A BVHAR model specification by \code{\link[=set_bvhar]{set_bvhar()}} (default) or \code{\link[=set_weight_bvhar]{set_weight_bvhar()}}.}

\item{include_mean}{Add constant term (Default: \code{TRUE}) or not (\code{FALSE})}

\item{x}{\code{bvarmn} object}

\item{digits}{digit option to print}

\item{...}{not used}
}
\value{
\code{bvhar_minnesota()} returns an object \code{bvharmn} \link{class}.
It is a list with the following components:

\describe{
\item{coefficients}{Posterior Mean matrix of Matrix Normal distribution}
\item{fitted.values}{Fitted values}
\item{residuals}{Residuals}
\item{mn_prec}{Posterior precision matrix of Matrix Normal distribution}
\item{iw_scale}{Posterior scale matrix of posterior inverse-wishart distribution}
\item{iw_shape}{Posterior shape of inverse-Wishart distribution (\eqn{\nu_0} - obs + 2). \eqn{\nu_0}: nrow(Dummy observation) - k}
\item{df}{Numer of Coefficients: 3m + 1 or 3m}
\item{p}{3, this element exists to run the other functions}
\item{week}{Order for weekly term}
\item{month}{Order for monthly term}
\item{m}{Dimension of the time series}
\item{obs}{Sample size used when training = \code{totobs} - 22}
\item{totobs}{Total number of the observation}
\item{call}{Matched call}
\item{process}{Process string in the \code{bayes_spec}: \code{"BVHAR_MN_VAR"} (BVHAR-S) or \code{"BVHAR_MN_VHAR"} (BVHAR-L)}
\item{spec}{Model specification (\code{bvharspec})}
\item{type}{include constant term (\code{"const"}) or not (\code{"none"})}
\item{prior_mean}{Prior mean matrix of Matrix Normal distribution: \eqn{M_0}}
\item{prior_precision}{Prior precision matrix of Matrix Normal distribution: \eqn{\Omega_0^{-1}}}
\item{prior_scale}{Prior scale matrix of inverse-Wishart distribution: \eqn{\Psi_0}}
\item{prior_shape}{Prior shape of inverse-Wishart distribution: \eqn{\nu_0}}
\item{HARtrans}{VHAR linear transformation matrix: \eqn{C_{HAR}}}
\item{y0}{\eqn{Y_0}}
\item{design}{\eqn{X_0}}
\item{y}{Raw input (\code{matrix})}
}
It is also \code{normaliw} and \code{bvharmod} class.
}
\description{
This function fits BVHAR with Minnesota prior.
}
\details{
Apply Minnesota prior to Vector HAR: \eqn{\Phi} (VHAR matrices) and \eqn{\Sigma_e} (residual covariance).

\deqn{\Phi \mid \Sigma_e \sim MN(M_0, \Omega_0, \Sigma_e)}
\deqn{\Sigma_e \sim IW(\Psi_0, \nu_0)}
(MN: \href{https://en.wikipedia.org/wiki/Matrix_normal_distribution}{matrix normal}, IW: \href{https://en.wikipedia.org/wiki/Inverse-Wishart_distribution}{inverse-wishart})

There are two types of Minnesota priors for BVHAR:
\itemize{
\item VAR-type Minnesota prior specified by \code{\link[=set_bvhar]{set_bvhar()}}, so-called BVHAR-S model.
\item VHAR-type Minnesota prior specified by \code{\link[=set_weight_bvhar]{set_weight_bvhar()}}, so-called BVHAR-L model.
}

Two types of Minnesota priors builds different dummy variables for Y0.
See \link{var_design_formulation}.
}
\examples{
# Perform the function using etf_vix dataset
fit <- bvhar_minnesota(y = etf_vix[,1:3])
class(fit)

# Extract coef, fitted values, and residuals
coef(fit)
head(residuals(fit))
head(fitted(fit))
}
\references{
Kim, Y. G., and Baek, C. (2023). \emph{Bayesian vector heterogeneous autoregressive modeling}. Journal of Statistical Computation and Simulation.
}
\seealso{
\itemize{
\item \code{\link[=set_bvhar]{set_bvhar()}} to specify the hyperparameters of BVHAR-S
\item \code{\link[=set_weight_bvhar]{set_weight_bvhar()}} to specify the hyperparameters of BVHAR-L
\item \code{\link[=coef.bvharmn]{coef.bvharmn()}}, \code{\link[=residuals.bvharmn]{residuals.bvharmn()}}, and \code{\link[=fitted.bvharmn]{fitted.bvharmn()}}
\item \code{\link[=summary.normaliw]{summary.normaliw()}} to summarize BVHAR model
\item \code{\link[=predict.bvharmn]{predict.bvharmn()}} to forecast the BVHAR process
}
}
