% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-forecast.R, R/print-forecast.R
\name{forecast_roll}
\alias{forecast_roll}
\alias{print.bvharcv}
\alias{knit_print.bvharcv}
\title{Out-of-sample Forecasting based on Rolling Window}
\usage{
forecast_roll(object, n_ahead, y_test, roll_thread = 1, mod_thread = 1)

\method{print}{bvharcv}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{knit_print}{bvharcv}(x, ...)
}
\arguments{
\item{object}{Model object}

\item{n_ahead}{Step to forecast in rolling window scheme}

\item{y_test}{Test data to be compared. Use \code{\link[=divide_ts]{divide_ts()}} if you don't have separate evaluation dataset.}

\item{roll_thread}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Number of threads when rolling window}

\item{mod_thread}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Number of threads when fitting the models}

\item{x}{\code{bvharcv} object}

\item{digits}{digit option to print}

\item{...}{not used}
}
\value{
\code{predbvhar_roll} \link{class}
}
\description{
This function conducts rolling window forecasting.
}
\details{
Rolling windows forecasting fixes window size.
It moves the window ahead and forecast h-ahead in \code{y_test} set.
}
\references{
Hyndman, R. J., & Athanasopoulos, G. (2021). \emph{Forecasting: Principles and practice} (3rd ed.). OTEXTS.
}
\seealso{
See \link{ts_forecasting_cv} for out-of-sample forecasting methods.
}
