% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate-param.R
\name{sim_mnvhar_coef}
\alias{sim_mnvhar_coef}
\title{Generate Minnesota BVAR Parameters}
\usage{
sim_mnvhar_coef(bayes_spec = set_bvhar(), full = TRUE)
}
\arguments{
\item{bayes_spec}{A BVHAR model specification by \code{\link[=set_bvhar]{set_bvhar()}} (default) or \code{\link[=set_weight_bvhar]{set_weight_bvhar()}}.}

\item{full}{Generate variance matrix from IW (default: \code{TRUE}) or not (\code{FALSE})?}
}
\value{
List with the following component.
\describe{
\item{coefficients}{BVHAR coefficient (MN)}
\item{covmat}{BVHAR variance (IW or diagonal matrix of \code{sigma} of \code{bayes_spec})}
}
}
\description{
This function generates parameters of BVAR with Minnesota prior.
}
\details{
Normal-IW family for vector HAR model:
\deqn{\Phi \mid \Sigma_e \sim MN(M_0, \Omega_0, \Sigma_e)}
\deqn{\Sigma_e \sim IW(\Psi_0, \nu_0)}
}
\examples{
# Generate (Phi, Sigma)
# BVHAR-S
# sigma: 1, 1, 1
# lambda: .1
# delta: .1, .1, .1
# epsilon: 1e-04
set.seed(1)
sim_mnvhar_coef(
  bayes_spec = set_bvhar(
    sigma = rep(1, 3),
    lambda = .1,
    delta = rep(.1, 3),
    eps = 1e-04
  ),
  full = TRUE
)
}
\references{
Kim, Y. G., and Baek, C. (2024). \emph{Bayesian vector heterogeneous autoregressive modeling}. Journal of Statistical Computation and Simulation, 94(6), 1139-1157.
}
\seealso{
\itemize{
\item \code{\link[=set_bvhar]{set_bvhar()}} to specify the hyperparameters of VAR-type Minnesota prior.
\item \code{\link[=set_weight_bvhar]{set_weight_bvhar()}} to specify the hyperparameters of HAR-type Minnesota prior.
}
}
