% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-sparse.R
\name{relspne}
\alias{relspne}
\alias{relspne.bvharsp}
\title{Evaluate the Estimation Based on Relative Spectral Norm Error}
\usage{
relspne(x, y, ...)

\method{relspne}{bvharsp}(x, y, ...)
}
\arguments{
\item{x}{Estimated model.}

\item{y}{Coefficient matrix to be compared.}

\item{...}{not used}
}
\value{
Spectral norm value
}
\description{
This function computes relative estimation error given estimated model and true coefficient.
}
\details{
Let \eqn{\lVert \cdot \rVert_2} be the spectral norm of a matrix,
let \eqn{\hat{\Phi}} be the estimates,
and let \eqn{\Phi} be the true coefficients matrix.
Then the function computes relative estimation error by
\deqn{\frac{\lVert \hat{\Phi} - \Phi \rVert_2}{\lVert \Phi \rVert_2}}
}
\references{
Ghosh, S., Khare, K., & Michailidis, G. (2018). \emph{High-Dimensional Posterior Consistency in Bayesian Vector Autoregressive Models}. Journal of the American Statistical Association, 114(526).
}
